//$Networking::ConnectIP = "aloshi.nitramtj.com";
//$Networking::Port = "28000";


//---------------------------------------------------------------------------------------------
// createServer
// Creates a server and connects to it locally.
//---------------------------------------------------------------------------------------------
$serverCreated = false;
function createServer(%displayOnMaster)
{
   // Destroy a potentially already created server.
   destroyServer();

   // Make sure the network port is set correctly.
   %failCount = 0;
   %port = $pref::net::port;
   while(%failCount < 10 && !setNetPort(%port))
   {
      echo("Port init failed on port " @ %port @ " trying next port.");
      %port++;
      %failCount++;
   }
   
   allowConnections(true);
   if (%displayOnMaster)
      schedule(0, 0, startHeartbeat);
      
   //onServerCreated();
   
   $pref::Player::name = "Server"; //set name to server to avoid confusion
   
   %conn = new GameConnection(ServerConnection);
   %conn.setConnectArgs($pref::Player::name);
   %conn.connectLocal();
   
   $serverConnected = true;
   $serverLocal = true;
   $serverCreated = true;
}

//---------------------------------------------------------------------------------------------
// destroyServer
// Destroys the server.
//---------------------------------------------------------------------------------------------
function destroyServer()
{
   // Can't destroy what isn't created.
   if(!$serverCreated)
      return;
      
   $serverCreated = false;
      
   allowConnections(false);
   stopHeartbeat();

   // Delete all the clients.
   while (ClientGroup.getCount())
   {
      %client = ClientGroup.getObject(0);
      %client.delete();
   }
   
   echo("Destroy Server");
   
   // Clean up.
   //purgeResources();
   onServerDestroyed();
}

//---------------------------------------------------------------------------------------------
// onServerInfoQuery
//---------------------------------------------------------------------------------------------
function onServerInfoQuery()
{
   return "Doing OK";
}



//===========================================================================
//client connection stuff
function GameConnection::onConnectRequest(%client, %netAddress)
{
   echo("Connect request from: " @ %netAddress);
   return "";
}

//---------------------------------------------------------------------------------------------
// GameConnection.onConnect
// This function is called when a client connection is accepted.
//---------------------------------------------------------------------------------------------
function GameConnection::onConnect(%client, %name)
{
   // Send down the connection error info. The client is responsible for displaying this
   // message if a connection error occures.
   commandToClient(%client, 'SetConnectionError', $Pref::Server::ConnectionError);
   
   %client.setPlayerName(%name);
   echo("Client Connected: " @ %client @ " " @ %client.getAddress());
   $Server::PlayerCount++;
   
   // Tell everyone about the new guy.
   //messageAllExcept(%client, -1, 'ClientJoined', %client);
   
   // Tell the new guy about everyone else.
   sendClientList(%client);
   
   //Tell everyone else about the new client.
   commandToAllExcept(%client, 'createClient', %client.name, %client.getId());
   
   //onClientConnected(%client);
}

//---------------------------------------------------------------------------------------------
// GameConnection.onDrop
// This function is called when a client drops for any reason.
//---------------------------------------------------------------------------------------------
function GameConnection::onDrop(%client, %reason)
{
   removeTaggedString(%client.name);
   echo("Client Dropped: " @ %client @ " " @ %client.getAddress());
   $Server::PlayerCount--;
   
   //tell everyone that a client left
   commandToAllExcept(%client, 'deleteClient', %client.getId());
   
   //messageAllExcept(%client, -1, 'ClientDropped', %client);
   
   //onClientDropped(%client);
}

//---------------------------------------------------------------------------------------------
// GameConnection.setPlayerName
// Sets %clients name based on %name. If %name is already used, a number is appended or
// incremented until the name is unique.
//---------------------------------------------------------------------------------------------
function GameConnection::setPlayerName(%client, %name)
{
	 %name = strreplace(%name, " ", ""); //do not allow spaces
   echo("name = " @ %name);
   
   // If nothing was passed, set a default name.
   %name = trim(%name);
   if (%name $= "")
      %name = "TGB Gamer";

   // Make sure the name is unique, we'll hit something eventually.
   %nameTest = %name;
   %count = 0;
   while(!isNameUnique(%nameTest))
   {
      %count++;
      %nameTest = %name @ %count;
   }

   // Set the name.
   %client.name = %nameTest;
}

//---------------------------------------------------------------------------------------------
// isNameUnique
// Checks if %name is not used by any clients.
//---------------------------------------------------------------------------------------------
function isNameUnique(%name)
{
   %count = ClientGroup.getCount();
   for (%i = 0; %i < %count; %i++)
   {
      %client = ClientGroup.getObject(%i);
      %test = detag(getTaggedString(%client.name));
      if (strcmp(%name, %test) == 0)
         return false;
   }
   
   // If we get here, the name is unique.
   return true;
}

function serverCmdMessageSent(%client, %text)
{
	%text = trim(%text);
	if(%text !$= "")
		commandToAll('chatMessage', %client.name @ ": " @ %text);
}

//command to all clients
function commandToAll(%func, %arg1, %arg2, %arg3, %arg4, %arg5, %arg6, %arg7, %arg8, %arg9, %arg10, %arg11, %arg12)
{
	for(%i = 0; %i < clientGroup.getCount(); %i++)
	{
		commandToClient(clientGroup.getObject(%i), %func, %arg1, %arg2, %arg3, %arg4, %arg5, %arg6, %arg7, %arg8, %arg9, %arg10, %arg11, %arg12);
	}
}

function commandToAllExcept(%client, %func, %arg1, %arg2, %arg3, %arg4, %arg5, %arg6, %arg7, %arg8, %arg9, %arg10, %arg11, %arg12)
{
	for(%i = 0; %i < clientGroup.getCount(); %i++)
	{
		if(clientGroup.getObject(%i) != %client)
			commandToClient(clientGroup.getObject(%i), %func, %arg1, %arg2, %arg3, %arg4, %arg5, %arg6, %arg7, %arg8, %arg9, %arg10, %arg11, %arg12);
	}
}

function sendClientList(%client)
{
	commandToClient(%client, 'clearPlayerList');
	
	for(%i = 0; %i < clientGroup.getCount(); %i++)
	{
		%cl = clientGroup.getObject(%i);
		if(%cl != %client)
		{
			commandToClient(%client, 'createClient', %cl.name, %cl.getId());
			commandToClient(%client, 'updatePlayerStatus', %cl.getId(), %cl.posX, %cl.posY, %cl.imageMap, %cl.velX, %cl.velY);
		}
	}
}

function serverCmdReceivePlayerStatus(%client, %x, %y, %img, %vx, %vy)
{
	%client.posX = %x;
	%client.posY = %y;
	%client.imageMap = %img;
	%client.velX = %vx;
	%client.velY = %vy;
	commandToAllExcept(%client, 'updatePlayerStatus', %client.getId(), %x, %y, %img, %vx, %vy);
}

//send the entire level to the specified client
function sendLevel(%client)
{

}
